; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	FUNCTION p_format, header
;
; PURPOSE:
;	Format an internal PDS header as external PDS text
;
; CALLING SEQUENCE:
;	 Result = p_format(header)
;
; INPUTS:
;   header:   The PDS header to be formated
;
; RETURNS:
;	string array with the PDS external text header
;
; KEYWORD PARAMETERS:
;	NONE
;
; EXAMPLE:
; 	h = p_newhead()
;   txt = p_format(h)
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 12/05-2004
;-
PRO extract_ns, tag, ns, label
	p = strpos(tag, '.', /REVERSE_SEARCH)

	if p ge 0 then begin
		ns = strmid(tag, 0, p-1)
		label = strmid(tag, p+1)
	endif else begin
		ns = ''
		label = tag
	endelse
END

FUNCTION fmt_pds_line, indent, label, value
	idx = string('', FORMAT='(A' + strtrim(indent*4, 2) + ')')

	; handle comments
	if label eq '' then return, idx + value

	; handle tags
	;len = strlen(label)
	;plen = 42 - len
	;fc = '(A' + strtrim(plen, 2) + ')'
	;return, idx + label + string('', FORMAT=fc) + ' = ' + value

	c = strmid(value, 0, 1)

	if c eq '"' then begin
		len = strlen(label)
		plen = 42 - len
		fc = '(A' + strtrim(plen, 2) + ')'
		dc = p_string_decode(value)
		ret = [idx + label + string('', FORMAT=fc) + ' = ' + dc[0]]
		for i=1, n_elements(dc)-1 do ret = [ret, dc[i]]
		return, ret
	endif else begin
		len = strlen(label)
		plen = 42 - len
		fc = '(A' + strtrim(plen, 2) + ')'
		return, idx + label + string('', FORMAT=fc) + ' = ' + value
	endelse

END


FUNCTION p_format, header

	out = ['']

	level = 0;
	ns = ''
	indent = 0

	for i=0, n_elements(header.tags)-1 do begin
		if header.tags[i] eq '' then begin ; handle comments
			tmp_line = ''

			; first handle the case where the line is the first line in a comment
			if i le 0 OR header.tags[i-1] ne '' then begin
				out = [out, '']
				tmp_line = '/*' + fmt_pds_line(indent, '', header.values[i])
			endif else begin
				; now just add the comment text
				tmp_line += fmt_pds_line(indent, '', header.values[i])
			endelse

			; finally handle the case where the comment line is the last line is the comment block
			if i eq n_elements(header.tags)-1 OR header.tags[i+1] ne '' then begin
				tmp_line += '*/'
				out = [out, tmp_line]
				out = [out, '']
			endif else out = [out, tmp_line]
		endif else if header.tags[i] eq 'G>' then begin
			out = [out, fmt_pds_line(indent, 'GROUP', header.values[i])]
			indent = indent + 1
			ns = ns + '.' + header.values[i]
		endif else if header.tags[i] eq 'G<' then begin
			indent = indent - 1
			out = [out, fmt_pds_line(indent, 'END_GROUP', header.values[i])]
			extract_ns, ns, ns, tmp
		endif else if header.tags[i] eq 'O>' then begin
			out = [out, fmt_pds_line(indent, 'OBJECT', header.values[i])]
			indent = indent + 1
			ns = ns + '.' + header.values[i]
		endif else if header.tags[i] eq 'O<' then begin
			indent = indent - 1
			out = [out, fmt_pds_line(indent, 'END_OBJECT', header.values[i])]
			extract_ns, ns, ns, tmp
		endif else begin
			extract_ns, header.tags[i], tmp, lbl
			out = [out, fmt_pds_line(indent, lbl, header.values[i])]
		endelse
	endfor

	out = [out, 'END']

	return, out[1:*]
END