; NAME:
;   FUNCTION p_extract_tags, header
;
; PURPOSE:
;   Extract a list of all tags available in a PDS header
;
; CALLING SEQUENCE:
;   Result = p_extract_tags(header)
;
; INPUTS:
;   header:     valid PDS header
;
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;   Nothing
;
; RETURNS:
;   A string array of fully qualified tags (including group/object paths) on success
;   -1 on error
;
; EXAMPLE:
;   header = p_newhead()
;   print, p_extract_tags(header)
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid, 20/11-2005
;-

FUNCTION p_extract_tags, header

    if p_is_header(header) eq 0 then return, -1

    out = ['']

    tp = ''
    for i=0, n_elements(header.tags)-1 do begin
       t = header.tags[i]

       if t eq 'O>' OR t eq 'G>' then begin
         if tp eq '' then tp = header.values[i] else tp = tp + '.' + header.values[i]
       endif else if t eq 'O<' OR t eq 'G<' then begin
        p_parse_tag_path, tp, tmpp, tmpn
        tp = tmpp
       endif else begin

        tag = tp
        if tag eq '' then tag = header.tags[i] else tag = tp + '.' + header.tags[i]
        out = [out, tag]
       endelse
    endfor

    return, out[1:*]

END