; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	PRO p_parse_tag_path, tag_path, nodes, name
;
; PURPOSE:
;	Split a PDS header tag path into its path section and name section
;   Example:   'IMAGE.FIRST_LINE' will be returned as path: ['IMAGE'] and tag: 'FIRST_LINE'
;
; CALLING SEQUENCE:
;	p_parse_tag_path, tag_path, nodes, name, ROOT_LEVEL=ROOT_LEVEL
;
; INPUTS:
;	tag_path:		Fully qualified PDS header tag
;					Example:   'IMAGE.FIRST_LINE'
;
;  OUTPUT:
;	nodes:	strarr() with the parsed out node members of the path
;   name:   The name of the fully qualified tag
;
; KEYWORD PARAMETERS:
;	ROOT_LEVEL:		Will be 1 if the input tag is a root level tag else 0
;
; EXAMPLE:
;	p_parse_tag_path, 'IMAGE.FIRST_LINE', path, name
;   print, path		; will be ['IMAGE']
;   print, name		; will be 'FIRST_LINE'
;
;	p_parse_tag_path, 'GROUP1.GROUP2.GROUP3.TAG_NAME', path, name
;   print, path		; will be ['GROUP1', 'GROUP2', 'GROUP3']
;   print, name		; will be 'TAG_NAME'
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 27/08-2004
;-

PRO p_parse_tag_path, tag_path, nodes, name, ROOT_LEVEL=ROOT_LEVEL

	nodes = strsplit(tag_path, '.', /extract)

	if n_elements(nodes) eq 1 then begin
		name = nodes[0]
		nodes = ['']
		ROOT_LEVEL = 1
	endif else begin
		name = nodes[n_elements(nodes)-1]
		nodes = nodes[0:n_elements(nodes)-2]
		ROOT_LEVEL = 0
	endelse
END
