; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
; Unauthorized reproduction prohibited.
;+
; NAME:
; FUNCTION p_remove_tag_namespace, tag
;
; PURPOSE:
; Remove any namespace reference from a tag
;
; CALLING SEQUENCE:
;  new_tag = p_remove_tag_namespace(tag)
;
; INPUTS:
;   tag:  The tag string to be processed
;
; RETURNS:
;   The modified tag without any namespace part
;
; KEYWORD PARAMETERS:
; IDL_COMPATIBLE_POINTER:    If set any '^' character in the tag will be changed to '_PTR_'
;
; EXAMPLE:
;   tag = p_remove_tag_namespace("ROSETTA:TEST_TAG")
;   print, tag    ; will be the value 'TEST_TAG'
;
; MODIFICATION HISTORY:
;   Written by: Stubbe F. Hviid, 30/4-2009
;-

FUNCTION p_remove_tag_namespace, tag, IDL_COMPATIBLE_POINTER=IDL_COMPATIBLE_POINTER

  if size(tag, /type) ne 7 then begin
    print, 'ERROR: Input to p_remove_namespace() must be a string'
    return, ''
  endif

  ; copy input tag to local variable
  ret = tag;

  ; extract path part of the tag
  p = rstrpos(ret, '.')

  if p gt 0 then begin
    path = strmid(ret, 0, p)
    ret = strmid(ret, p+1)
  endif else path = ''

  ; look for namespace seperator (':')
  p = strpos(ret, ':')
  
  ; if found return the string part after the ':' character 
  if p gt 0 then begin
    ret = strmid(ret, p+1)
  endif
  
  if keyword_set(IDL_COMPATIBLE_POINTER) then begin
    if strmid(ret, 0, 1) eq '^' then ret = '_PTR_' + strmid(ret, 1)
  endif

  ; handle path statements
  if path ne '' then return, path + '.' + ret

  ; handle single tag statements
  return, ret
END