; Copyright (c) 2004, Stubbe F. Hviid @ Max Planck Institut fur Sonnensystemforschung
;   Unauthorized reproduction prohibited.
;+
; NAME:
;   FUNCTION p_timenow()
;
; PURPOSE:
;   Return the current time as a string formated in the std format: YYYYMMDDTHH:MM:SS
;
; CATEGORY:
;   Time handling
;
; CALLING SEQUENCE:
;  Result = p_timenow()
;
; INPUTS:
;   None
;
; KEYWORD PARAMETERS:
;   NONE
;
; OUTPUTS:
;   None
;
; RETURNS:
;   Current time formateed as YYYYMMDDTHH:MM:SS
;
; RESTRICTIONS:
;	None
;
; EXAMPLE:
;   print, p_timenow()
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid   27/6-2005
;-

FUNCTION p_timenow
	stime = SYSTIME(/UTC)

	year  = strmid(stime, 20, 4)
	month = strmid(stime, 4, 3)
	day = strmid(stime, 8, 2)
	time  = strmid(stime, 11, 8)

	amonths = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
	s = where(month eq amonths)
	month = s[0]+1


	return, year + '-' + string(month, FORMAT='(I02)') + '-' + day + 'T' + time
END