; NAME:
;   PRO p_list_header_content, filelist, header_tags, DIR=DIR
;
; PURPOSE:
;   Generate a report showing the values of selected header tags within a list of files
;
; CALLING SEQUENCE:
;   p_list_header_content, filelist, header_tags
;
; INPUTS:
;   filelist:   string array with the filenames of the pds files to be included in the report
;   header_tags: string array with the tags to be included in the report
;
; KEYWORD PARAMETERS:
;   DIR:    	If set <filelist> should be a text string with the path of a directory
;           	The filelist will then be all the files within this directory
;	CSV:		Generate CSV formated output (command seperated values)
;   FILENAME: 	Used to specify an output filename used to save the values
;   SHOW: 		Show a text widget with the output
;
; OUTPUTS:
;   Nothing
;
; RETURNS:
;   Nothing
;
; EXAMPLE:
;   p_list_header_content, ['img1.img','img2.img'], ['TAG1', 'TAG2']    ; list TAG1 and TAG2 in img1 and img2
;   p_list_header_content, 'c:\temp', ['TAG1', 'TAG2']  ; list TAG1 and TAG2 in all img files within c:\temp
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid, 26/10-2004
;-
PRO p_list_header_content, filelist, header_tags, DIR=DIR, CSV=CSV, FILENAME=FILENAME, SHOW=SHOW

    if keyword_set(DIR) then filelist = findfile(filelist + "/*.img")

	if keyword_set(CSV) then begin
		l = 'Filename'
		for i=0, n_elements(header_tags)-1 do l = l + ',' + header_tags[i]
		report = [l]
	endif else report = ['']

    for i=0, n_elements(filelist)-1 do begin
       fn = p_parse_file_path(filelist[i])
       if keyword_set(DIR) then file = fn.filename else file = filelist[i]

	   fp = p_parse_file_path(filelist[i])

	   if keyword_set(CSV) then out = fp.filename else  out = string(fp.filename, FORMAT='(A60)')

       p_rhead, filelist[i], h
       for j=0, n_elements(header_tags)-1 do begin

         v = p_value(h, header_tags[j], /AS_STRING)
         if keyword_set(CSV) then begin
         	p = strpos(v, ',')
         	while p ge 0 do begin
				vv = strmid(v, 0, p) + ';' + strmid(v, p+1)
				v = vv
				p = strpos(v, ',');
			endwhile
         	if strpos(v, ',') ge 0 then v = '"' + v + '"'
			out = out + "," + string(v)
		 endif else begin
         	out = out + "  " + header_tags[j] + ": " + string(v)
         endelse
       endfor

       report = [report, out]
    endfor

	if keyword_set(SHOW) then p_show_text, report
	if n_elements(FILENAME) ne 0 then begin
		openw, unit, FILENAME, /GET_LUN
		for i=0, n_elements(report)-1 do printf, unit, report[i]
		close, unit
		free_lun, unit
	endif else begin
		for i=0, n_elements(report)-1 do print, report[i]
	endelse

END