; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	PRO p_read, file, header, image, OK=OK
;
; PURPOSE:
;	Read image data and header from a PDS/VICAR file
;
; CALLING SEQUENCE:
;	 p_read, file, header, image, OK=OK
;
; INPUTS:
;   file:   The file to read from
;
; OUTPUT:
;	header:			the output PDS header
;   image:  		the output image
;	object_name:	the name of the PDS image object to extract (Defaults to 'IMAGE')
;
; KEYWORD PARAMETERS:
;	OK		  will be 1 on success else 0
;   VERBOSE   set to enable all progress print statements (only errors will be shown)
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 12/05-2004
;-

PRO p_read, file, header, image, object_name, OK=OK, _EXTRA=_EXTRA

	p_rhead, file, header, OK=OK, _EXTRA=_EXTRA

	if OK eq 0 then return

	image = p_read_image_object(header, object_name, OK=OK, _EXTRA=_EXTRA);
END
