; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	PRO p_add_tag, header, tag, value, INSERT_INDEX=INSERT_INDEX
;
; PURPOSE:
;	Add or insert a tag into a PDS header
;  (Low level utility routine - not for normal use)
;
; CALLING SEQUENCE:
;	  p_add_tag, header, tag, value, status, INSERT_INDEX=INSERT_INDEX
;
; INPUTS:
;	header:	Valid PDS header structure to be modified
;   tag:    Tag path of the item to be add/inserted
;   value:  the value to be written
;
; KEYWORD PARAMETERS:
;	INSERT_INDEX:	If specified the tag will be inserted at the INSERT_INDEX index within the header
;
; EXAMPLE:
; 	p_read, pickfile(), h, d
;	p_add_tag, h, 'HELLO', 'WORLD', INSERT_INDEX=10		; insert tag a index 10
;	p_add_tag, h, 'THIS', 'IS A TEST'			; just add the tag read teh status
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 11/08-2004
;-

PRO p_add_tag, header, tag, value, INSERT_INDEX=INSERT_INDEX

	; Verify input
	if p_is_header(header) eq 0 then stop
	if n_elements(tag) eq 0 then stop
	if n_elements(value) eq 0 then stop

	; Add the tag
	if n_elements(INSERT_INDEX) ne 0 then begin

		if INSERT_INDEX ge 0 AND INSERT_INDEX lt n_elements(header.tags) then begin
			if INSERT_INDEX eq 0 then begin
				tags = [tag, header.tags]
				values = [value, header.values]
			endif else begin
				tags = [header.tags[0:INSERT_INDEX-1], tag, header.tags[INSERT_INDEX:*]]
				values = [header.values[0:INSERT_INDEX-1], value, header.values[INSERT_INDEX:*]]
			endelse
			header = p_set_struct_tag(header, 'tags', tags, 'values', values)
			return
		endif
	endif

	; at this point just add the nex tag
	tags = [header.tags, tag]
	values = [header.values, value]

	header = p_set_struct_tag(header, 'tags', tags, 'values', values)
END